############
#RC1 SQL
############
#Increase the sizes of the configuration key and configuration title database fields.
alter table configuration modify configuration_title varchar(255) NOT NULL;
alter table configuration modify configuration_key varchar(255) NOT NULL;

#Add a new configuration parameter to control the maximum quantity number a product can be ordered (default 99).
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Quantities In Shopping Cart', 'MAX_QTY_IN_CART', '99', 'Maximum number of product quantities that can be added to the shopping cart (0 for no limit)', '3', '19', now());

DROP TABLE IF EXISTS administrators;
CREATE TABLE administrators (
  id int NOT NULL auto_increment,
  user_name varchar(32) binary NOT NULL,
  user_password varchar(40) NOT NULL,
  PRIMARY KEY (id)
);

############
#RC2 SQL
############
#Add indexes to increase performance
#Add public and download status flag fields to the orders_status table
#Increase payment_method field size on the orders table
#Increase the last_page_url field size on the whos_online table
alter table banners add index idx_banners_group (banners_group);
alter table banners_history add index idx_banners_history_banners_id (banners_id);
alter table currencies add index idx_currencies_code (code);
alter table customers add index idx_customers_email_address (customers_email_address);
alter table customers_basket add index idx_customers_basket_customers_id (customers_id);
alter table customers_basket_attributes add index idx_customers_basket_att_customers_id (customers_id);
alter table orders add index idx_orders_customers_id (customers_id);
alter table orders_products add index idx_orders_products_orders_id (orders_id);
alter table orders_products add index idx_orders_products_products_id (products_id);
alter table orders_status_history add index idx_orders_status_history_orders_id (orders_id);
alter table orders_products_attributes add index idx_orders_products_att_orders_id (orders_id);
alter table orders_products_download add index idx_orders_products_download_orders_id (orders_id);
alter table products add index idx_products_model (products_model);
alter table products_attributes add index idx_products_attributes_products_id (products_id);
alter table reviews add index idx_reviews_products_id (products_id);
alter table reviews add index idx_reviews_customers_id (customers_id);
alter table specials add index idx_specials_products_id (products_id);
alter table zones add index idx_zones_country_id (zone_country_id);
alter table zones_to_geo_zones add index idx_zones_to_geo_zones_country_id (zone_country_id);

alter table orders_status add public_flag int DEFAULT '1';
alter table orders_status add downloads_flag int DEFAULT '0';

alter table orders modify payment_method varchar(255) NOT NULL;

alter table whos_online modify last_page_url text NOT NULL;

# Add new column to reviews table
ALTER TABLE reviews ADD reviews_status TINYINT(1) NOT NULL DEFAULT '0';

############
#2.3.0 SQL
############
#Update Database Field Lengths
alter table address_book modify entry_gender char(1);
alter table address_book modify entry_company varchar(255);
alter table address_book modify entry_firstname varchar(255) NOT NULL;
alter table address_book modify entry_lastname varchar(255) NOT NULL;
alter table address_book modify entry_street_address varchar(255) NOT NULL;
alter table address_book modify entry_suburb varchar(255);
alter table address_book modify entry_postcode varchar(255) NOT NULL;
alter table address_book modify entry_city varchar(255) NOT NULL;
alter table address_book modify entry_state varchar(255);
alter table administrators modify user_name varchar(255) binary NOT NULL;
alter table configuration modify configuration_value text NOT NULL;
alter table countries modify countries_name varchar(255) NOT NULL;
alter table customers modify customers_gender char(1);
alter table customers modify customers_firstname varchar(255) NOT NULL;
alter table customers modify customers_lastname varchar(255) NOT NULL;
alter table customers modify customers_email_address varchar(255) NOT NULL;
alter table customers modify customers_telephone varchar(255) NOT NULL;
alter table customers modify customers_fax varchar(255);
alter table orders modify customers_name varchar(255) NOT NULL;
alter table orders modify customers_company varchar(255);
alter table orders modify customers_street_address varchar(255) NOT NULL;
alter table orders modify customers_suburb varchar(255);
alter table orders modify customers_city varchar(255) NOT NULL;
alter table orders modify customers_postcode varchar(255) NOT NULL;
alter table orders modify customers_state varchar(255);
alter table orders modify customers_country varchar(255) NOT NULL;
alter table orders modify customers_telephone varchar(255) NOT NULL;
alter table orders modify customers_email_address varchar(255) NOT NULL;
alter table orders modify delivery_name varchar(255) NOT NULL;
alter table orders modify delivery_company varchar(255);
alter table orders modify delivery_street_address varchar(255) NOT NULL;
alter table orders modify delivery_suburb varchar(255);
alter table orders modify delivery_city varchar(255) NOT NULL;
alter table orders modify delivery_postcode varchar(255) NOT NULL;
alter table orders modify delivery_state varchar(255);
alter table orders modify delivery_country varchar(255) NOT NULL;
alter table orders modify billing_name varchar(255) NOT NULL;
alter table orders modify billing_company varchar(255);
alter table orders modify billing_street_address varchar(255) NOT NULL;
alter table orders modify billing_suburb varchar(255);
alter table orders modify billing_city varchar(255) NOT NULL;
alter table orders modify billing_postcode varchar(255) NOT NULL;
alter table orders modify billing_state varchar(255);
alter table orders modify billing_country varchar(255) NOT NULL;
alter table orders modify cc_owner varchar(255);
alter table reviews modify customers_name varchar(255) NOT NULL;
alter table whos_online modify full_name varchar(255) NOT NULL;
alter table zones modify zone_name varchar(255) NOT NULL;

#Introduce Security Directory Permissions Feature
CREATE TABLE sec_directory_whitelist (
id int NOT NULL auto_increment,
directory varchar(255) NOT NULL,
PRIMARY KEY (id)
);
INSERT INTO sec_directory_whitelist values (null, 'admin/backups');
INSERT INTO sec_directory_whitelist values (null, 'admin/images/graphs');
INSERT INTO sec_directory_whitelist values (null, 'images');
INSERT INTO sec_directory_whitelist values (null, 'images/banners');
INSERT INTO sec_directory_whitelist values (null, 'images/dvd');
INSERT INTO sec_directory_whitelist values (null, 'images/gt_interactive');
INSERT INTO sec_directory_whitelist values (null, 'images/hewlett_packard');
INSERT INTO sec_directory_whitelist values (null, 'images/matrox');
INSERT INTO sec_directory_whitelist values (null, 'images/microsoft');
INSERT INTO sec_directory_whitelist values (null, 'images/sierra');
INSERT INTO sec_directory_whitelist values (null, 'includes/work');
INSERT INTO sec_directory_whitelist values (null, 'pub');

#Introduce Action Recorder Feature
CREATE TABLE action_recorder (
id int NOT NULL auto_increment,
module varchar(255) NOT NULL,
user_id int,
user_name varchar(255),
identifier varchar(255) NOT NULL,
success char(1),
date_added datetime NOT NULL,
PRIMARY KEY (id),
KEY idx_action_recorder_module (module),
KEY idx_action_recorder_user_id (user_id),
KEY idx_action_recorder_identifier (identifier),
KEY idx_action_recorder_date_added (date_added)
);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value,
configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed
Modules', 'MODULE_ACTION_RECORDER_INSTALLED',
'ar_admin_login.php;ar_contact_us.php;ar_tell_a_friend.php', 'List of action recorder module
filenames separated by a semi-colon. This is automatically updated. No need to edit.', '6', '0',
now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value,
configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Minimum
Minutes Per E-Mail', 'MODULE_ACTION_RECORDER_CONTACT_US_EMAIL_MINUTES', '15', 'Minimum number of
minutes to allow 1 e-mail to be sent (eg, 15 for 1 e-mail every 15 minutes)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value,
configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Minimum
Minutes Per E-Mail', 'MODULE_ACTION_RECORDER_TELL_A_FRIEND_EMAIL_MINUTES', '15', 'Minimum number
of minutes to allow 1 e-mail to be sent (eg, 15 for 1 e-mail every 15 minutes)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value,
configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Allowed
Minutes', 'MODULE_ACTION_RECORDER_ADMIN_LOGIN_MINUTES', '5', 'Number of minutes to allow login
attempts to occur.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value,
configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Allowed
Attempts', 'MODULE_ACTION_RECORDER_ADMIN_LOGIN_ATTEMPTS', '3', 'Number of login attempts to allow
within the specified period.', '6', '0', now());

#Update Password Hashing to Phpass
alter table administrators modify user_password varchar(60) NOT NULL;
alter table customers modify customers_password varchar(60) NOT NULL;

CREATE TABLE IF NOT EXISTS `products_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `image` varchar(64) DEFAULT NULL,
  `htmlcontent` text,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `products_images_prodid` (`products_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;


############
#2.3.1 SQL
############
#None

############
#2.3.2 SQL
############
#password security improvement
alter table customers_info add password_reset_key char(40);
alter table customers_info add password_reset_date datetime;

############
#2.3.3 SQL
############
#none.

############
#2.3.4 SQL
############
#Increase column size
alter table sessions modify sesskey varchar(128) not null;

#Adds "Administration Tool -> Configuration -> Shipping/Packaging -> Allow Orders Not Matching Defined Shipping Zones"
insert into configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Allow Orders Not Matching Defined Shipping Zones ', 'SHIPPING_ALLOW_UNDEFINED_ZONES', 'False', 'Should orders be allowed to shipping addresses not matching defined shipping module shipping zones?', '7', '5', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now());